//*************************************************************************************************************************************
//
//  Sample Program for Communicate (RS232)
//
//  Target Machine : CPT-711
//
//  Function:
//  int  SetCommType (int port, int type)
//          Set the communication type of the port specified.
//          Port 1 :  0  direct RS-232
//                    1  docking(RS-485 communication)
//          Port 2 :  2  via IR transceiver
//                    3  standard IrDA communication
//                    4  RF communication
//  void open_com(int port, int parameter) : Initialize and enable specified the COM port.
//  void write_com(int port, char *s)      : Send a string out thuough the COM port.
//  int  com_eot(int port)                 : To see if any COM port transmission in process(End Of Transmission).
//  viod close_com(int port)               : To close specified communication port.
//  int  read_com(int port, char *s)       : Read 1 byte from the COM port receive buffer.
//
//  SYNTECH INFORMATION CO., LTD.
//
//*************************************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

int  iPort=1, iType=0, iBaudRate=0x08;
int  beep1[4] = { 16, 5, 0, 0 };

void main (void)
    {
    int   i, iret;
    char  cda, sda[100];

    clr_scr ();
    gotoxy (3, 0);
    puts ("COMM. RS232 TEST");

    SetCommType (iPort, iType);

    gotoxy (4, 2);
    if (open_com (iPort, iBaudRate))
        puts ("OPEN COM OK");
    else
        puts ("OPEN COM NG");

    gotoxy (4, 6);
    puts ("ENT TO WRITE");
    while (getchar() != KEY_CR);

    strcpy (sda, "CIPHER\r\n");
    write_com (iPort, sda);
    while ( !com_eot(iPort) );

    gotoxy (4, 3);
    puts ("WRITE:");
    for (i=0; i<6; i++)
        putchar (sda[i]);

    clear_com (iPort);

    gotoxy (4, 6);
    puts ("ENT TO READ ");
    while (getchar() != KEY_CR);

    gotoxy (4, 6);
    puts ("START TO READ");

    gotoxy (4, 4);

ReadTry:

    i = 0;
    while (i<10)
        {
        if (read_com (iPort, &cda))
            {
            sda[i++] = cda;
            putchar (cda);
            }

        if (cda == '\r')
            {
            on_beeper (beep1);
            break;
            }

        if (getchar() == KEY_ESC)
            goto ApEnd;
        }

    sda[i] = 0;
    if (!strcmp (sda, "CIPHER\r"))
        {
        gotoxy (4, 5);
        puts ("READ:");
        for (i=0; i<6; i++)
            putchar (sda[i]);
        }
    else
        goto ReadTry;

ApEnd:

    gotoxy (4, 6);
    if (close_com (iPort))
        puts ("CLOSE COM OK ");
    else
        puts ("CLOSE COM NG ");

    while (getchar() != KEY_ESC);
    }

//-------------------------------------------------------------------------//
